require "BuildingObjects/ISBuildingObject"

HCBarbedWireBarricade = ISBuildingObject:derive("HCBarbedWireBarricade");

function HCBarbedWireBarricade:create(x, y, z, north, sprite, spriteN)
	local cell = getWorld():getCell();
	local eHP = getSpecificPlayer(self.player):getPerkLevel(Perks.Woodwork)*1000;
	local objHP = 2000 + eHP;
	if getSpecificPlayer(self.player):HasTrait("Handy") then
		objHP = objHP + 100;
	end
	self.sq = cell:getGridSquare(x, y, z);
	self.javaObject = IsoThumpable.new(cell, self.sq, sprite, north, self);
	buildUtil.setInfo(self.javaObject, self);
	local self2 = self;
	self2.modData["need:Hydrocraft.HCBarbedwirebarricade"] = "1";
	buildUtil.consumeMaterial(self2);
	self2 = nil;
	self.javaObject:setMaxHealth(objHP);
	self.javaObject:setBreakSound("breakdoor");
	self.sq:AddSpecialObject(self.javaObject);
	self.sq:RecalcAllWithNeighbours(true);
	self.javaObject:transmitCompleteItemToServer();
end

function HCBarbedWireBarricade:new(sprite, spriteN, player)
	local o = {};
	setmetatable(o, self);
	self.__index = self;
	o:init();
	o:setSprite(sprite);
	o:setNorthSprite(spriteN);
	o.name = "Barbed Wire Barricade";
	o.canBarricade = false;
	o.dismantable = false;
	o.blockAllTheSquare = true;
	o.canBeAlwaysPlaced = false;
	o.noNeedHammer = true;
	o.character = player;
	return o;
end

function HCBarbedWireBarricade.onDestroy(thump, player)
	if thump:getName() ~= "Barbed Wire Barricade" then return end
	for x=0, 1+ZombRand(3) do
		thump:getSquare():AddWorldInventoryItem("Base.BarbedWire", 0.0, 0.0, 0.0);
	end
	thump:getSquare():transmitRemoveItemFromSquare(thump);
	thump:getSquare():RemoveTileObject(thump);
end

function HCBarbedWireBarricade:render(x, y, z, square)
	ISBuildingObject.render(self, x, y, z, square);
end

Events.OnDestroyIsoThumpable.Add(HCBarbedWireBarricade.onDestroy);